/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4JournalHeaderS
implements StructConverter {
    private int h_magic;
    private int h_blocktype;
    private int h_sequence;

    public Ext4JournalHeaderS(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, false));
    }

    public Ext4JournalHeaderS(BinaryReader reader) throws IOException {
        reader.setLittleEndian(false);
        this.h_magic = reader.readNextInt();
        this.h_blocktype = reader.readNextInt();
        this.h_sequence = reader.readNextInt();
    }

    public int getH_magic() {
        return this.h_magic;
    }

    public int getH_blocktype() {
        return this.h_blocktype;
    }

    public int getH_sequence() {
        return this.h_sequence;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("journal_header_s", 0);
        structure.add(DWORD, "h_magic", null);
        structure.add(DWORD, "h_blocktype", null);
        structure.add(DWORD, "h_sequence", null);
        return structure;
    }
}

