/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FilledArrayDataPayload
implements StructConverter {
    public static final short MAGIC = 768;
    private short ident;
    private short elementWidth;
    private int size;
    private byte[] data;

    public FilledArrayDataPayload(BinaryReader reader) throws IOException {
        this.ident = reader.readNextShort();
        this.elementWidth = reader.readNextShort();
        this.size = reader.readNextInt();
        this.data = reader.readNextByteArray(this.size * this.elementWidth);
    }

    public short getIdent() {
        return this.ident;
    }

    public short getElementWidth() {
        return this.elementWidth;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getData() {
        return this.data;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("filled_array_data_payload_" + this.elementWidth + "_" + this.size, 0);
        structure.add(WORD, "ident", null);
        structure.add(WORD, "element_width", null);
        structure.add(DWORD, "size", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.size * this.elementWidth, BYTE.getLength()), "data", null);
        structure.setCategoryPath(new CategoryPath("/dex/filled_array_data_payload"));
        return structure;
    }
}

