/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import ghidra.service.graph.Attributed;

public class AttributedVertex
extends Attributed {
    public static final String NAME_KEY = "Name";
    public static final String VERTEX_TYPE_KEY = "VertexType";
    private final String id;

    public AttributedVertex(String id, String name) {
        this.id = id;
        this.setName(name);
    }

    public AttributedVertex(String id) {
        this(id, id);
    }

    public void setName(String name) {
        this.setAttribute(NAME_KEY, name);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.getAttribute(NAME_KEY);
    }

    public String toString() {
        return this.getName() + " (" + this.id + ")";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributedVertex other = (AttributedVertex)obj;
        return this.id.equals(other.id);
    }

    public String getVertexType() {
        return this.getAttribute(VERTEX_TYPE_KEY);
    }

    public void setVertexType(String vertexType) {
        this.setAttribute(VERTEX_TYPE_KEY, vertexType);
    }
}

