/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number.parse;

import org.python.icu.impl.StaticUnicodeSets;
import org.python.icu.impl.StringSegment;
import org.python.icu.impl.number.parse.ParsedNumber;
import org.python.icu.impl.number.parse.SymbolMatcher;
import org.python.icu.text.DecimalFormatSymbols;

public class PercentMatcher
extends SymbolMatcher {
    private static final PercentMatcher DEFAULT = new PercentMatcher();

    public static PercentMatcher getInstance(DecimalFormatSymbols symbols2) {
        String symbolString = symbols2.getPercentString();
        if (PercentMatcher.DEFAULT.uniSet.contains(symbolString)) {
            return DEFAULT;
        }
        return new PercentMatcher(symbolString);
    }

    private PercentMatcher(String symbolString) {
        super(symbolString, PercentMatcher.DEFAULT.uniSet);
    }

    private PercentMatcher() {
        super(StaticUnicodeSets.Key.PERCENT_SIGN);
    }

    @Override
    protected boolean isDisabled(ParsedNumber result2) {
        return 0 != (result2.flags & 2);
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result2) {
        result2.flags |= 2;
        result2.setCharsConsumed(segment);
    }

    public String toString() {
        return "<PercentMatcher>";
    }
}

