/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeThread;

public interface Stepper {
    public static Stepper instruction() {
        return Enum.INSTRUCTION;
    }

    public static Stepper pcode() {
        return Enum.PCODE;
    }

    public void tick(PcodeThread<?> var1);

    public void skip(PcodeThread<?> var1);

    public static enum Enum implements Stepper
    {
        INSTRUCTION{

            @Override
            public void tick(PcodeThread<?> thread) {
                thread.stepInstruction();
            }

            @Override
            public void skip(PcodeThread<?> thread) {
                thread.skipInstruction();
            }
        }
        ,
        PCODE{

            @Override
            public void tick(PcodeThread<?> thread) {
                thread.stepPcodeOp();
            }

            @Override
            public void skip(PcodeThread<?> thread) {
                thread.skipPcodeOp();
            }
        };

    }
}

