/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.jungrapht;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import ghidra.util.Msg;
import java.awt.Shape;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jungrapht.visualization.layout.algorithms.EdgeAwareTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.EiglspergerLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TidierTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Layering;
import org.jungrapht.visualization.layout.algorithms.util.VertexBoundsFunctionConsumer;
import org.jungrapht.visualization.layout.model.Rectangle;

public class JgtLayoutFactory<V extends FGVertex, E extends FGEdge> {
    private static List<String> layoutNames = List.of("Compact Hierarchical", "Hierarchical", "Hierarchical MinCross Top Down", "Hierarchical MinCross Longest Path", "Hierarchical MinCross Network Simplex", "Hierarchical MinCross Coffman Graham", "Vertical Hierarchical MinCross Top Down", "Vertical Hierarchical MinCross Longest Path", "Vertical Hierarchical MinCross Network Simplex", "Vertical Hierarchical MinCross Coffman Graham");
    private Predicate<E> favoredEdgePredicate;
    private Comparator<E> edgeTypeComparator;
    private Predicate<V> rootPredicate;

    public JgtLayoutFactory(Comparator<E> comparator, Predicate<E> favoredEdgePredicate, Predicate<V> rootPredicate) {
        this.edgeTypeComparator = comparator;
        this.favoredEdgePredicate = favoredEdgePredicate;
        this.rootPredicate = rootPredicate;
    }

    public static List<String> getSupportedLayoutNames() {
        return layoutNames;
    }

    public LayoutAlgorithm<V> getLayout(String name) {
        LayoutAlgorithm.Builder<V, ?, ?> layoutBuilder = this.doGetLayout(name);
        LayoutAlgorithm layout = layoutBuilder.build();
        if (layout instanceof TreeLayout) {
            ((TreeLayout)layout).setRootPredicate(this.rootPredicate);
        }
        if (layout instanceof VertexBoundsFunctionConsumer) {
            VertexBoundsFunctionConsumer boundsLayout = (VertexBoundsFunctionConsumer)layout;
            FGVertexShapeFunction vertexBoundsFunction = new FGVertexShapeFunction(this);
            boundsLayout.setVertexBoundsFunction((Function)vertexBoundsFunction);
        }
        return layout;
    }

    private LayoutAlgorithm.Builder<V, ?, ?> doGetLayout(String name) {
        switch (name) {
            case "Compact Hierarchical": {
                return TidierTreeLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator);
            }
            case "Hierarchical": {
                return EdgeAwareTreeLayoutAlgorithm.edgeAwareBuilder();
            }
            case "Hierarchical MinCross Top Down": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).layering(Layering.TOP_DOWN)).threaded(false);
            }
            case "Hierarchical MinCross Longest Path": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).layering(Layering.LONGEST_PATH)).threaded(false);
            }
            case "Hierarchical MinCross Network Simplex": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).layering(Layering.NETWORK_SIMPLEX)).threaded(false);
            }
            case "Hierarchical MinCross Coffman Graham": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).layering(Layering.COFFMAN_GRAHAM)).threaded(false);
            }
            case "Vertical Hierarchical MinCross Top Down": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).favoredEdgePredicate(this.favoredEdgePredicate)).layering(Layering.TOP_DOWN)).threaded(false);
            }
            case "Vertical Hierarchical MinCross Longest Path": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).favoredEdgePredicate(this.favoredEdgePredicate)).layering(Layering.LONGEST_PATH)).threaded(false);
            }
            case "Vertical Hierarchical MinCross Network Simplex": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).favoredEdgePredicate(this.favoredEdgePredicate)).layering(Layering.NETWORK_SIMPLEX)).threaded(false);
            }
            case "Vertical Hierarchical MinCross Coffman Graham": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).favoredEdgePredicate(this.favoredEdgePredicate)).layering(Layering.COFFMAN_GRAHAM)).threaded(false);
            }
        }
        Msg.error((Object)this, (Object)("Unknown graph layout type: '" + name + "'"));
        return null;
    }

    private class FGVertexShapeFunction
    implements Function<FGVertex, Rectangle> {
        private VisualGraphVertexShapeTransformer<FGVertex> vgShaper = new VisualGraphVertexShapeTransformer();

        private FGVertexShapeFunction(JgtLayoutFactory jgtLayoutFactory) {
        }

        @Override
        public Rectangle apply(FGVertex v) {
            Shape shape = this.vgShaper.apply((VisualVertex)v);
            java.awt.Rectangle r = shape.getBounds();
            return Rectangle.of((int)r.x, (int)r.y, (int)r.width, (int)r.height);
        }
    }
}

