/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.device;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.cache.CaffeineStatsCounter;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.device.DeviceRepresentationProvider;
import org.keycloak.device.DeviceRepresentationProviderFactory;
import org.keycloak.device.DeviceRepresentationProviderImpl;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import ua_parser.Client;
import ua_parser.Parser;

public class DeviceRepresentationProviderFactoryImpl
implements DeviceRepresentationProviderFactory {
    private static final Parser UA_PARSER = new Parser();
    private static final String CACHE_SIZE = "cacheSize";
    private static final int DEFAULT_CACHE_SIZE = 2048;
    private volatile LoadingCache<String, Client> cache;
    public static final String PROVIDER_ID = "deviceRepresentation";

    public String getId() {
        return PROVIDER_ID;
    }

    public void init(Config.Scope config) {
        CaffeineStatsCounter metrics = new CaffeineStatsCounter((MeterRegistry)Metrics.globalRegistry, "userAgent");
        this.cache = Caffeine.newBuilder().maximumSize((long)config.getInt(CACHE_SIZE, Integer.valueOf(2048)).intValue()).recordStats(() -> metrics).softValues().build(arg_0 -> ((Parser)UA_PARSER).parse(arg_0));
        metrics.registerSizeMetric(this.cache);
    }

    public DeviceRepresentationProvider create(KeycloakSession session) {
        return new DeviceRepresentationProviderImpl(session, this.cache);
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(CACHE_SIZE).type("Integer").helpText("Sets the maximum number of parsed user-agent values in the local cache.").defaultValue((Object)2048).add().build();
    }
}

