/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.server.log.remote.storage.LogSegmentData;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.storage.internals.log.StorageAction;

public class ClassLoaderAwareRemoteStorageManager
implements RemoteStorageManager {
    private final RemoteStorageManager delegate;
    private final ClassLoader rsmClassLoader;

    public ClassLoaderAwareRemoteStorageManager(RemoteStorageManager rsm, ClassLoader rsmClassLoader) {
        this.delegate = rsm;
        this.rsmClassLoader = rsmClassLoader;
    }

    public RemoteStorageManager delegate() {
        return this.delegate;
    }

    public void configure(Map<String, ?> configs) {
        this.withClassLoader(() -> {
            this.delegate.configure(configs);
            return null;
        });
    }

    public void close() throws IOException {
        this.withClassLoader(() -> {
            this.delegate.close();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Exception> T withClassLoader(StorageAction<T, E> action) throws E {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.rsmClassLoader);
        try {
            T t = action.execute();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public Optional<RemoteLogSegmentMetadata.CustomMetadata> copyLogSegmentData(RemoteLogSegmentMetadata remoteLogSegmentMetadata, LogSegmentData logSegmentData) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.copyLogSegmentData(remoteLogSegmentMetadata, logSegmentData));
    }

    public InputStream fetchLogSegment(RemoteLogSegmentMetadata remoteLogSegmentMetadata, int startPosition) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.fetchLogSegment(remoteLogSegmentMetadata, startPosition));
    }

    public InputStream fetchLogSegment(RemoteLogSegmentMetadata remoteLogSegmentMetadata, int startPosition, int endPosition) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.fetchLogSegment(remoteLogSegmentMetadata, startPosition, endPosition));
    }

    public InputStream fetchIndex(RemoteLogSegmentMetadata remoteLogSegmentMetadata, RemoteStorageManager.IndexType indexType) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.fetchIndex(remoteLogSegmentMetadata, indexType));
    }

    public void deleteLogSegmentData(RemoteLogSegmentMetadata remoteLogSegmentMetadata) throws RemoteStorageException {
        this.withClassLoader(() -> {
            this.delegate.deleteLogSegmentData(remoteLogSegmentMetadata);
            return null;
        });
    }
}

