/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.UnsafeUtil;
import com.jogamp.common.util.ValueConv;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.security.PrivilegedAction;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class Buffers {
    static final boolean DEBUG = Debug.debug("Buffers");
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    protected Buffers() {
    }

    public static ByteBuffer newDirectByteBuffer(int n) {
        return Buffers.nativeOrder(ByteBuffer.allocateDirect(n));
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n, int n2) {
        return (ByteBuffer)Buffers.newDirectByteBuffer(n2).put(byArray, n, n2).rewind();
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n) {
        return Buffers.newDirectByteBuffer(byArray, n, byArray.length - n);
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray) {
        return Buffers.newDirectByteBuffer(byArray, 0);
    }

    public static DoubleBuffer newDirectDoubleBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 8).asDoubleBuffer();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n, int n2) {
        return (DoubleBuffer)Buffers.newDirectDoubleBuffer(n2).put(dArray, n, n2).rewind();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n) {
        return Buffers.newDirectDoubleBuffer(dArray, n, dArray.length - n);
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray) {
        return Buffers.newDirectDoubleBuffer(dArray, 0);
    }

    public static FloatBuffer newDirectFloatBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 4).asFloatBuffer();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n, int n2) {
        return (FloatBuffer)Buffers.newDirectFloatBuffer(n2).put(fArray, n, n2).rewind();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n) {
        return Buffers.newDirectFloatBuffer(fArray, n, fArray.length - n);
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray) {
        return Buffers.newDirectFloatBuffer(fArray, 0);
    }

    public static IntBuffer newDirectIntBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 4).asIntBuffer();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n, int n2) {
        return (IntBuffer)Buffers.newDirectIntBuffer(n2).put(nArray, n, n2).rewind();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n) {
        return Buffers.newDirectIntBuffer(nArray, n, nArray.length - n);
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray) {
        return Buffers.newDirectIntBuffer(nArray, 0);
    }

    public static LongBuffer newDirectLongBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 8).asLongBuffer();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n, int n2) {
        return (LongBuffer)Buffers.newDirectLongBuffer(n2).put(lArray, n, n2).rewind();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n) {
        return Buffers.newDirectLongBuffer(lArray, n, lArray.length - n);
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray) {
        return Buffers.newDirectLongBuffer(lArray, 0);
    }

    public static ShortBuffer newDirectShortBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 2).asShortBuffer();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n, int n2) {
        return (ShortBuffer)Buffers.newDirectShortBuffer(n2).put(sArray, n, n2).rewind();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n) {
        return Buffers.newDirectShortBuffer(sArray, n, sArray.length - n);
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray) {
        return Buffers.newDirectShortBuffer(sArray, 0);
    }

    public static CharBuffer newDirectCharBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 2).asCharBuffer();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n, int n2) {
        return (CharBuffer)Buffers.newDirectCharBuffer(n2).put(cArray, n, n2).rewind();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n) {
        return Buffers.newDirectCharBuffer(cArray, n, cArray.length - n);
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray) {
        return Buffers.newDirectCharBuffer(cArray, 0);
    }

    public static ByteBuffer nativeOrder(ByteBuffer byteBuffer) {
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static Class<? extends Buffer> typeNameToBufferClass(String string) {
        if (string == null) {
            return null;
        }
        if ("byte".equals(string)) {
            return ByteBuffer.class;
        }
        if ("short".equals(string)) {
            return ShortBuffer.class;
        }
        if ("char".equals(string)) {
            return CharBuffer.class;
        }
        if ("int".equals(string)) {
            return IntBuffer.class;
        }
        if ("float".equals(string)) {
            return FloatBuffer.class;
        }
        if ("long".equals(string)) {
            return LongBuffer.class;
        }
        if ("double".equals(string)) {
            return DoubleBuffer.class;
        }
        return null;
    }

    public static int sizeOfBufferElem(Class<? extends Buffer> clazz) {
        if (clazz == null) {
            return 0;
        }
        if (ByteBuffer.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (ShortBuffer.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (CharBuffer.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (IntBuffer.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (FloatBuffer.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (LongBuffer.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (DoubleBuffer.class.isAssignableFrom(clazz)) {
            return 8;
        }
        throw new RuntimeException("Unexpected buffer type " + clazz.getName());
    }

    public static int sizeOfBufferElem(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof ByteBuffer) {
            return 1;
        }
        if (object instanceof IntBuffer) {
            return 4;
        }
        if (object instanceof ShortBuffer) {
            return 2;
        }
        if (object instanceof FloatBuffer) {
            return 4;
        }
        if (object instanceof DoubleBuffer) {
            return 8;
        }
        if (object instanceof LongBuffer) {
            return 8;
        }
        if (object instanceof CharBuffer) {
            return 2;
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).elementSize();
        }
        throw new RuntimeException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int remainingElem(Object object) throws IllegalArgumentException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).remaining();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).remaining();
        }
        throw new IllegalArgumentException("Unsupported anonymous buffer type: " + object.getClass().getCanonicalName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int remainingBytes(Object object) throws IllegalArgumentException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).remaining();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n * 4;
            }
            if (object instanceof IntBuffer) {
                return n * 4;
            }
            if (object instanceof ShortBuffer) {
                return n * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n * 8;
            }
            if (object instanceof LongBuffer) {
                return n * 8;
            }
            if (!(object instanceof CharBuffer)) throw new InternalError("Unsupported Buffer type: " + object.getClass().getCanonicalName());
            return n * 2;
        }
        if (!(object instanceof NativeBuffer)) throw new IllegalArgumentException("Unsupported anonymous buffer type: " + object.getClass().getCanonicalName());
        NativeBuffer nativeBuffer = (NativeBuffer)object;
        return nativeBuffer.remaining() * nativeBuffer.elementSize();
    }

    public static boolean isDirect(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).isDirect();
        }
        if (object instanceof PointerBuffer) {
            return ((PointerBuffer)object).isDirect();
        }
        throw new IllegalArgumentException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n * 4;
            }
            if (object instanceof IntBuffer) {
                return n * 4;
            }
            if (object instanceof ShortBuffer) {
                return n * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n * 8;
            }
            if (object instanceof LongBuffer) {
                return n * 8;
            }
            if (object instanceof CharBuffer) {
                return n * 2;
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.position() * nativeBuffer.elementSize();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static Object getArray(Object object) throws UnsupportedOperationException, IllegalArgumentException {
        if (object == null) {
            return null;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).array();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).array();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return ((ByteBuffer)object).arrayOffset() + n;
            }
            if (object instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)object).arrayOffset() + n);
            }
            if (object instanceof IntBuffer) {
                return 4 * (((IntBuffer)object).arrayOffset() + n);
            }
            if (object instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)object).arrayOffset() + n);
            }
            if (object instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)object).arrayOffset() + n);
            }
            if (object instanceof LongBuffer) {
                return 8 * (((LongBuffer)object).arrayOffset() + n);
            }
            if (object instanceof CharBuffer) {
                return 2 * (((CharBuffer)object).arrayOffset() + n);
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.elementSize() * (nativeBuffer.arrayOffset() + nativeBuffer.position());
        }
        throw new IllegalArgumentException("Unknown buffer type " + object.getClass().getName());
    }

    public static <B extends Buffer> B slice(B b) {
        if (b instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)b;
            return (B)byteBuffer.slice().order(byteBuffer.order());
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).slice();
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).slice();
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).slice();
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).slice();
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).slice();
        }
        if (b instanceof CharBuffer) {
            return (B)((CharBuffer)b).slice();
        }
        throw new IllegalArgumentException("unexpected buffer type: " + b.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B extends Buffer> B slice(B b, int n, int n2) {
        int n3 = b.position();
        int n4 = b.limit();
        B b2 = null;
        try {
            b.position(n).limit(n + n2);
            b2 = Buffers.slice(b);
        }
        finally {
            b.position(n3).limit(n4);
        }
        return b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FloatBuffer slice2Float(Buffer buffer, int n, int n2) {
        FloatBuffer floatBuffer;
        block6: {
            if (null == buffer) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n * 4);
                    byteBuffer.limit((n + n2) * 4);
                    floatBuffer = byteBuffer.slice().order(byteBuffer.order()).asFloatBuffer();
                    break block6;
                }
                if (buffer instanceof FloatBuffer) {
                    FloatBuffer floatBuffer2 = (FloatBuffer)buffer;
                    floatBuffer2.position(n);
                    floatBuffer2.limit(n + n2);
                    floatBuffer = floatBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor FloarBuffer, nor backing array given");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        floatBuffer.mark();
        return floatBuffer;
    }

    public static final FloatBuffer slice2Float(float[] fArray, int n, int n2) {
        return (FloatBuffer)FloatBuffer.wrap(fArray, n, n2).mark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ShortBuffer slice2Short(Buffer buffer, int n, int n2) {
        ShortBuffer shortBuffer;
        block6: {
            if (null == buffer) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n * 2);
                    byteBuffer.limit((n + n2) * 2);
                    shortBuffer = byteBuffer.slice().order(byteBuffer.order()).asShortBuffer();
                    break block6;
                }
                if (buffer instanceof ShortBuffer) {
                    ShortBuffer shortBuffer2 = (ShortBuffer)buffer;
                    shortBuffer2.position(n);
                    shortBuffer2.limit(n + n2);
                    shortBuffer = shortBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor ShortBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        shortBuffer.mark();
        return shortBuffer;
    }

    public static final ShortBuffer slice2Short(short[] sArray, int n, int n2) {
        return (ShortBuffer)ShortBuffer.wrap(sArray, n, n2).mark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CharBuffer slice2Char(Buffer buffer, int n, int n2) {
        CharBuffer charBuffer;
        block6: {
            if (null == buffer) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n * 2);
                    byteBuffer.limit((n + n2) * 2);
                    charBuffer = byteBuffer.slice().order(byteBuffer.order()).asCharBuffer();
                    break block6;
                }
                if (buffer instanceof CharBuffer) {
                    CharBuffer charBuffer2 = (CharBuffer)buffer;
                    charBuffer2.position(n);
                    charBuffer2.limit(n + n2);
                    charBuffer = charBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor CharBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        charBuffer.mark();
        return charBuffer;
    }

    public static final CharBuffer slice2Char(char[] cArray, int n, int n2) {
        return (CharBuffer)CharBuffer.wrap(cArray, n, n2).mark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IntBuffer slice2Int(Buffer buffer, int n, int n2) {
        IntBuffer intBuffer;
        block6: {
            if (null == buffer) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n * 4);
                    byteBuffer.limit((n + n2) * 4);
                    intBuffer = byteBuffer.slice().order(byteBuffer.order()).asIntBuffer();
                    break block6;
                }
                if (buffer instanceof IntBuffer) {
                    IntBuffer intBuffer2 = (IntBuffer)buffer;
                    intBuffer2.position(n);
                    intBuffer2.limit(n + n2);
                    intBuffer = intBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor IntBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        intBuffer.mark();
        return intBuffer;
    }

    public static final IntBuffer slice2Int(int[] nArray, int n, int n2) {
        return (IntBuffer)IntBuffer.wrap(nArray, n, n2).mark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LongBuffer slice2Long(Buffer buffer, int n, int n2) {
        LongBuffer longBuffer;
        block6: {
            if (null == buffer) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n * 8);
                    byteBuffer.limit((n + n2) * 8);
                    longBuffer = byteBuffer.slice().order(byteBuffer.order()).asLongBuffer();
                    break block6;
                }
                if (buffer instanceof LongBuffer) {
                    LongBuffer longBuffer2 = (LongBuffer)buffer;
                    longBuffer2.position(n);
                    longBuffer2.limit(n + n2);
                    longBuffer = longBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor LongBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        longBuffer.mark();
        return longBuffer;
    }

    public static final LongBuffer slice2Long(long[] lArray, int n, int n2) {
        return (LongBuffer)LongBuffer.wrap(lArray, n, n2).mark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DoubleBuffer slice2Double(Buffer buffer, int n, int n2) {
        DoubleBuffer doubleBuffer;
        block6: {
            if (null == buffer) {
                throw new IllegalArgumentException("Buffer is null");
            }
            int n3 = buffer.position();
            int n4 = buffer.limit();
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n * 8);
                    byteBuffer.limit((n + n2) * 8);
                    doubleBuffer = byteBuffer.slice().order(byteBuffer.order()).asDoubleBuffer();
                    break block6;
                }
                if (buffer instanceof DoubleBuffer) {
                    DoubleBuffer doubleBuffer2 = (DoubleBuffer)buffer;
                    doubleBuffer2.position(n);
                    doubleBuffer2.limit(n + n2);
                    doubleBuffer = doubleBuffer2.slice();
                    break block6;
                }
                throw new IllegalArgumentException("Buffer not ByteBuffer, nor DoubleBuffer");
            }
            finally {
                buffer.position(n3).limit(n4);
            }
        }
        doubleBuffer.mark();
        return doubleBuffer;
    }

    public static final DoubleBuffer slice2Double(double[] dArray, int n, int n2) {
        return (DoubleBuffer)DoubleBuffer.wrap(dArray, n, n2).mark();
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        byteBuffer.position(n);
        return byteBuffer2;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        return Buffers.copyFloatBufferAsByteBuffer(floatBuffer).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        return Buffers.copyIntBufferAsByteBuffer(intBuffer).asIntBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        return Buffers.copyShortBufferAsByteBuffer(shortBuffer).asShortBuffer();
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(floatBuffer.remaining() * 4);
        byteBuffer.asFloatBuffer().put(floatBuffer);
        byteBuffer.rewind();
        floatBuffer.position(n);
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        int n = intBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(intBuffer.remaining() * 4);
        byteBuffer.asIntBuffer().put(intBuffer);
        byteBuffer.rewind();
        intBuffer.position(n);
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        int n = shortBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(shortBuffer.remaining() * 2);
        byteBuffer.asShortBuffer().put(shortBuffer);
        byteBuffer.rewind();
        shortBuffer.position(n);
        return byteBuffer;
    }

    public static float[] getFloatArray(double[] dArray, int n, float[] fArray, int n2, int n3) {
        if (0 > n3) {
            n3 = dArray.length - n;
        }
        if (n3 > dArray.length - n) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining source bytes [len " + dArray.length + ", offset " + n + "]");
        }
        if (null == fArray) {
            fArray = new float[n3];
            n2 = 0;
        }
        if (n3 > fArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining dest bytes [len " + fArray.length + ", offset " + n2 + "]");
        }
        for (int i = 0; i < n3; ++i) {
            fArray[n2 + i] = (float)dArray[n + i];
        }
        return fArray;
    }

    public static FloatBuffer getFloatBuffer(DoubleBuffer doubleBuffer, FloatBuffer floatBuffer) {
        if (null == floatBuffer) {
            floatBuffer = Buffers.newDirectFloatBuffer(doubleBuffer.remaining());
        }
        if (floatBuffer.remaining() < doubleBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + doubleBuffer.remaining() + ") is greater than remaining dest bytes: " + floatBuffer.remaining());
        }
        while (doubleBuffer.hasRemaining()) {
            floatBuffer.put((float)doubleBuffer.get());
        }
        return floatBuffer;
    }

    public static double[] getDoubleArray(float[] fArray, int n, double[] dArray, int n2, int n3) {
        if (0 > n3) {
            n3 = fArray.length - n;
        }
        if (n3 > fArray.length - n) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining source bytes [len " + fArray.length + ", offset " + n + "]");
        }
        if (null == dArray) {
            dArray = new double[n3];
            n2 = 0;
        }
        if (n3 > dArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining dest bytes [len " + dArray.length + ", offset " + n2 + "]");
        }
        for (int i = 0; i < n3; ++i) {
            dArray[n2 + i] = fArray[n + i];
        }
        return dArray;
    }

    public static DoubleBuffer getDoubleBuffer(FloatBuffer floatBuffer, DoubleBuffer doubleBuffer) {
        if (null == doubleBuffer) {
            doubleBuffer = Buffers.newDirectDoubleBuffer(floatBuffer.remaining());
        }
        if (doubleBuffer.remaining() < floatBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + floatBuffer.remaining() + ") is greater than remaining dest bytes: " + doubleBuffer.remaining());
        }
        while (floatBuffer.hasRemaining()) {
            doubleBuffer.put(floatBuffer.get());
        }
        return doubleBuffer;
    }

    public static <B extends Buffer> B put(B b, Buffer buffer) {
        if (b instanceof ByteBuffer && buffer instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put((ByteBuffer)buffer);
        }
        if (b instanceof ShortBuffer && buffer instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put((ShortBuffer)buffer);
        }
        if (b instanceof IntBuffer && buffer instanceof IntBuffer) {
            return (B)((IntBuffer)b).put((IntBuffer)buffer);
        }
        if (b instanceof FloatBuffer && buffer instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((FloatBuffer)buffer);
        }
        if (b instanceof LongBuffer && buffer instanceof LongBuffer) {
            return (B)((LongBuffer)b).put((LongBuffer)buffer);
        }
        if (b instanceof DoubleBuffer && buffer instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put((DoubleBuffer)buffer);
        }
        if (b instanceof CharBuffer && buffer instanceof CharBuffer) {
            return (B)((CharBuffer)b).put((CharBuffer)buffer);
        }
        throw new IllegalArgumentException("Incompatible Buffer classes: dest = " + b.getClass().getName() + ", src = " + buffer.getClass().getName());
    }

    public static <B extends Buffer> B putb(B b, byte by) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(by);
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(by);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(by);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(by);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(by);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(by);
        }
        if (b instanceof CharBuffer) {
            return (B)((CharBuffer)b).put((char)by);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3b(B b, byte by, byte by2, byte by3) {
        if (b instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)b;
            byteBuffer.put(by);
            byteBuffer.put(by2);
            byteBuffer.put(by3);
            return (B)byteBuffer;
        }
        if (b instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)b;
            shortBuffer.put(by);
            shortBuffer.put(by2);
            shortBuffer.put(by3);
            return (B)shortBuffer;
        }
        if (b instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)b;
            intBuffer.put(by);
            intBuffer.put(by2);
            intBuffer.put(by3);
            return (B)intBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put(by);
            floatBuffer.put(by2);
            floatBuffer.put(by3);
            return (B)floatBuffer;
        }
        if (b instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)b;
            longBuffer.put(by);
            longBuffer.put(by2);
            longBuffer.put(by3);
            return (B)longBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(by);
            doubleBuffer.put(by2);
            doubleBuffer.put(by3);
            return (B)doubleBuffer;
        }
        if (b instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)b;
            charBuffer.put((char)by);
            charBuffer.put((char)by2);
            charBuffer.put((char)by3);
            return (B)charBuffer;
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put4b(B b, byte by, byte by2, byte by3, byte by4) {
        if (b instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)b;
            byteBuffer.put(by);
            byteBuffer.put(by2);
            byteBuffer.put(by3);
            byteBuffer.put(by4);
            return (B)byteBuffer;
        }
        if (b instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)b;
            shortBuffer.put(by);
            shortBuffer.put(by2);
            shortBuffer.put(by3);
            shortBuffer.put(by4);
            return (B)shortBuffer;
        }
        if (b instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)b;
            intBuffer.put(by);
            intBuffer.put(by2);
            intBuffer.put(by3);
            intBuffer.put(by4);
            return (B)intBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put(by);
            floatBuffer.put(by2);
            floatBuffer.put(by3);
            floatBuffer.put(by4);
            return (B)floatBuffer;
        }
        if (b instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)b;
            longBuffer.put(by);
            longBuffer.put(by2);
            longBuffer.put(by3);
            longBuffer.put(by4);
            return (B)longBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(by);
            doubleBuffer.put(by2);
            doubleBuffer.put(by3);
            doubleBuffer.put(by4);
            return (B)doubleBuffer;
        }
        if (b instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)b;
            charBuffer.put((char)by);
            charBuffer.put((char)by2);
            charBuffer.put((char)by3);
            charBuffer.put((char)by4);
            return (B)charBuffer;
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putb(B b, byte[] byArray, int n, int n2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(byArray, n, n2);
        }
        if (b instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)b;
            for (int i = 0; i < n2; ++i) {
                shortBuffer.put(byArray[n + i]);
            }
            return (B)shortBuffer;
        }
        if (b instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)b;
            for (int i = 0; i < n2; ++i) {
                intBuffer.put(byArray[n + i]);
            }
            return (B)intBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            for (int i = 0; i < n2; ++i) {
                floatBuffer.put(byArray[n + i]);
            }
            return (B)floatBuffer;
        }
        if (b instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)b;
            for (int i = 0; i < n2; ++i) {
                longBuffer.put(byArray[n + i]);
            }
            return (B)longBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            for (int i = 0; i < n2; ++i) {
                doubleBuffer.put(byArray[n + i]);
            }
            return (B)doubleBuffer;
        }
        if (b instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)b;
            for (int i = 0; i < n2; ++i) {
                charBuffer.put((char)byArray[n + i]);
            }
            return (B)charBuffer;
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B puts(B b, short s) {
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(s);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(s);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(s);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(s);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(s);
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3s(B b, short s, short s2, short s3) {
        if (b instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)b;
            shortBuffer.put(s);
            shortBuffer.put(s2);
            shortBuffer.put(s3);
            return (B)shortBuffer;
        }
        if (b instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)b;
            intBuffer.put(s);
            intBuffer.put(s2);
            intBuffer.put(s3);
            return (B)intBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put(s);
            floatBuffer.put(s2);
            floatBuffer.put(s3);
            return (B)floatBuffer;
        }
        if (b instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)b;
            longBuffer.put(s);
            longBuffer.put(s2);
            longBuffer.put(s3);
            return (B)longBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(s);
            doubleBuffer.put(s2);
            doubleBuffer.put(s3);
            return (B)doubleBuffer;
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put4s(B b, short s, short s2, short s3, short s4) {
        if (b instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)b;
            shortBuffer.put(s);
            shortBuffer.put(s2);
            shortBuffer.put(s3);
            shortBuffer.put(s4);
            return (B)shortBuffer;
        }
        if (b instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)b;
            intBuffer.put(s);
            intBuffer.put(s2);
            intBuffer.put(s3);
            intBuffer.put(s4);
            return (B)intBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put(s);
            floatBuffer.put(s2);
            floatBuffer.put(s3);
            floatBuffer.put(s4);
            return (B)floatBuffer;
        }
        if (b instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)b;
            longBuffer.put(s);
            longBuffer.put(s2);
            longBuffer.put(s3);
            longBuffer.put(s4);
            return (B)longBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(s);
            doubleBuffer.put(s2);
            doubleBuffer.put(s3);
            doubleBuffer.put(s4);
            return (B)doubleBuffer;
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B puts(B b, short[] sArray, int n, int n2) {
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(sArray, n, n2);
        }
        if (b instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)b;
            for (int i = 0; i < n2; ++i) {
                intBuffer.put(sArray[n + i]);
            }
            return (B)intBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            for (int i = 0; i < n2; ++i) {
                floatBuffer.put(sArray[n + i]);
            }
            return (B)floatBuffer;
        }
        if (b instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)b;
            for (int i = 0; i < n2; ++i) {
                longBuffer.put(sArray[n + i]);
            }
            return (B)longBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            for (int i = 0; i < n2; ++i) {
                doubleBuffer.put(sArray[n + i]);
            }
            return (B)doubleBuffer;
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B puti(B b, int n) {
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(n);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(n);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(n);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(n);
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3i(B b, int n, int n2, int n3) {
        if (b instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)b;
            intBuffer.put(n);
            intBuffer.put(n2);
            intBuffer.put(n3);
            return (B)intBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put(n);
            floatBuffer.put(n2);
            floatBuffer.put(n3);
            return (B)floatBuffer;
        }
        if (b instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)b;
            longBuffer.put(n);
            longBuffer.put(n2);
            longBuffer.put(n3);
            return (B)longBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(n);
            doubleBuffer.put(n2);
            doubleBuffer.put(n3);
            return (B)doubleBuffer;
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put4i(B b, int n, int n2, int n3, int n4) {
        if (b instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)b;
            intBuffer.put(n);
            intBuffer.put(n2);
            intBuffer.put(n3);
            intBuffer.put(n4);
            return (B)intBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put(n);
            floatBuffer.put(n2);
            floatBuffer.put(n3);
            floatBuffer.put(n4);
            return (B)floatBuffer;
        }
        if (b instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)b;
            longBuffer.put(n);
            longBuffer.put(n2);
            longBuffer.put(n3);
            longBuffer.put(n4);
            return (B)longBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(n);
            doubleBuffer.put(n2);
            doubleBuffer.put(n3);
            doubleBuffer.put(n4);
            return (B)doubleBuffer;
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B puti(B b, int[] nArray, int n, int n2) {
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(nArray, n, n2);
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            for (int i = 0; i < n2; ++i) {
                floatBuffer.put(nArray[n + i]);
            }
            return (B)floatBuffer;
        }
        if (b instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)b;
            for (int i = 0; i < n2; ++i) {
                longBuffer.put(nArray[n + i]);
            }
            return (B)longBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            for (int i = 0; i < n2; ++i) {
                doubleBuffer.put(nArray[n + i]);
            }
            return (B)doubleBuffer;
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putf(B b, float f) {
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(f);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(f);
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3f(B b, float f, float f2, float f3) {
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put(f);
            floatBuffer.put(f2);
            floatBuffer.put(f3);
            return (B)floatBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(f);
            doubleBuffer.put(f2);
            doubleBuffer.put(f3);
            return (B)doubleBuffer;
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put4f(B b, float f, float f2, float f3, float f4) {
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put(f);
            floatBuffer.put(f2);
            floatBuffer.put(f3);
            floatBuffer.put(f4);
            return (B)floatBuffer;
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(f);
            doubleBuffer.put(f2);
            doubleBuffer.put(f3);
            doubleBuffer.put(f4);
            return (B)doubleBuffer;
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putf(B b, float[] fArray, int n, int n2) {
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(fArray, n, n2);
        }
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            for (int i = 0; i < n2; ++i) {
                doubleBuffer.put(fArray[n + i]);
            }
            return (B)doubleBuffer;
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putd(B b, double d) {
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(d);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((float)d);
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put3d(B b, double d, double d2, double d3) {
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(d);
            doubleBuffer.put(d2);
            doubleBuffer.put(d3);
            return (B)doubleBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put((float)d);
            floatBuffer.put((float)d2);
            floatBuffer.put((float)d3);
            return (B)floatBuffer;
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B put4d(B b, double d, double d2, double d3, double d4) {
        if (b instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)b;
            doubleBuffer.put(d);
            doubleBuffer.put(d2);
            doubleBuffer.put(d3);
            doubleBuffer.put(d4);
            return (B)doubleBuffer;
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            floatBuffer.put((float)d);
            floatBuffer.put((float)d2);
            floatBuffer.put((float)d3);
            floatBuffer.put((float)d4);
            return (B)floatBuffer;
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putd(B b, double[] dArray, int n, int n2) {
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(dArray, n, n2);
        }
        if (b instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)b;
            for (int i = 0; i < n2; ++i) {
                floatBuffer.put((float)dArray[n + i]);
            }
            return (B)floatBuffer;
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNb(B b, boolean bl, byte by, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(by);
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.byte_to_short(by, bl2, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.byte_to_int(by, bl2, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.byte_to_float(by, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNs(B b, boolean bl, short s, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.short_to_byte(s, bl2, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(s);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.short_to_int(s, bl2, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.short_to_float(s, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNi(B b, boolean bl, int n, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.int_to_byte(n, bl2, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.int_to_short(n, bl2, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(n);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.int_to_float(n, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNf(B b, boolean bl, float f) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.float_to_byte(f, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.float_to_short(f, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.float_to_int(f, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(f);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static void rangeCheck(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        if (byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (byArray.length - n));
        }
    }

    public static void rangeCheck(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return;
        }
        if (cArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (cArray.length - n));
        }
    }

    public static void rangeCheck(short[] sArray, int n, int n2) {
        if (sArray == null) {
            return;
        }
        if (sArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (sArray.length - n));
        }
    }

    public static void rangeCheck(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return;
        }
        if (nArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (nArray.length - n));
        }
    }

    public static void rangeCheck(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return;
        }
        if (lArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (lArray.length - n));
        }
    }

    public static void rangeCheck(float[] fArray, int n, int n2) {
        if (fArray == null) {
            return;
        }
        if (fArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (fArray.length - n));
        }
    }

    public static void rangeCheck(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return;
        }
        if (dArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (dArray.length - n));
        }
    }

    public static void rangeCheck(Buffer buffer, int n) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Object object, int n) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (object == null) {
            return;
        }
        int n2 = Buffers.remainingBytes(object);
        if (n2 < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining bytes in buffer, only had " + n2);
        }
    }

    public static StringBuilder toString(StringBuilder stringBuilder, String string, Buffer buffer) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(buffer.getClass().getSimpleName());
        stringBuilder.append("[pos ").append(buffer.position()).append(", lim ").append(buffer.limit()).append(", cap ").append(buffer.capacity());
        stringBuilder.append(", remaining ").append(buffer.remaining());
        stringBuilder.append("; array ").append(buffer.hasArray()).append(", direct ").append(buffer.isDirect());
        stringBuilder.append(", r/w ").append(!buffer.isReadOnly()).append(": ");
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            for (int i = 0; i < byteBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(byteBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, byteBuffer.get(i)));
            }
        } else if (buffer instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            for (int i = 0; i < floatBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(floatBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, Float.valueOf(floatBuffer.get(i))));
            }
        } else if (buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            for (int i = 0; i < intBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(intBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, intBuffer.get(i)));
            }
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            for (int i = 0; i < shortBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(shortBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, shortBuffer.get(i)));
            }
        } else if (buffer instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)buffer;
            for (int i = 0; i < doubleBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(doubleBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, doubleBuffer.get(i)));
            }
        } else if (buffer instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)buffer;
            for (int i = 0; i < longBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(longBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, longBuffer.get(i)));
            }
        } else if (buffer instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)buffer;
            for (int i = 0; i < charBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(charBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, Character.valueOf(charBuffer.get(i))));
            }
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public static ByteBuffer copyNativeToDirectByteBuffer(long l, long l2) {
        if (Integer.MAX_VALUE < l2) {
            throw new IllegalArgumentException("length " + l2 + " > MAX_INT");
        }
        int n = (int)l2;
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(n);
        if (null == byteBuffer) {
            throw new RuntimeException("New direct ByteBuffer is NULL");
        }
        if (0 < n) {
            long l3 = Buffers.getDirectBufferAddressImpl(byteBuffer);
            Buffers.memcpyImpl(l3, l, n);
        }
        return byteBuffer;
    }

    public static long getDirectBufferAddress(Object object) {
        return Buffers.getDirectBufferAddressImpl(object);
    }

    static ByteBuffer getDirectByteBuffer(long l, int n) {
        ByteBuffer byteBuffer = Buffers.getDirectByteBufferImpl(l, n);
        return null != byteBuffer ? Buffers.nativeOrder(byteBuffer) : null;
    }

    static void storeDirectAddress(long l, ByteBuffer byteBuffer, int n, int n2) {
        switch (n2) {
            case 4: {
                byteBuffer.putInt(n, (int)(l & 0xFFFFFFFFL));
                break;
            }
            case 8: {
                byteBuffer.putLong(n, l);
                break;
            }
            default: {
                throw new InternalError("invalid nativeSizeInBytes " + n2);
            }
        }
    }

    public static int strnlen(long l, int n) {
        return Buffers.strnlenImpl(l, n);
    }

    static native long getDirectBufferAddressImpl(Object var0);

    private static native ByteBuffer getDirectByteBufferImpl(long var0, int var2);

    private static native int strnlenImpl(long var0, int var2);

    private static native long memcpyImpl(long var0, long var2, long var4);

    public static class Cleaner {
        private static final Method mbbCleaner;
        private static final Method cClean;
        private static volatile boolean cleanerError;

        public static boolean clean(ByteBuffer byteBuffer) {
            if (cleanerError || !byteBuffer.isDirect()) {
                return false;
            }
            try {
                if (PlatformPropsImpl.JAVA_9) {
                    UnsafeUtil.invokeCleaner(byteBuffer);
                } else {
                    cClean.invoke(mbbCleaner.invoke((Object)byteBuffer, new Object[0]), new Object[0]);
                }
                return true;
            }
            catch (Throwable throwable) {
                cleanerError = true;
                if (DEBUG) {
                    ExceptionUtils.dumpThrowable("Buffers", throwable);
                }
                return false;
            }
        }

        static {
            boolean bl;
            final Method[] methodArray = new Method[]{null};
            final Method[] methodArray2 = new Method[]{null};
            if (SecurityUtil.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        if (PlatformPropsImpl.JAVA_9) {
                            return UnsafeUtil.hasInvokeCleaner();
                        }
                        methodArray[0] = ReflectionUtil.getMethod("sun.nio.ch.DirectBuffer", "cleaner", null, Buffers.class.getClassLoader());
                        methodArray[0].setAccessible(true);
                        Class<?> clazz = methodArray[0].getReturnType();
                        methodArray2[0] = clazz.getMethod("clean", new Class[0]);
                        methodArray2[0].setAccessible(true);
                        return Boolean.TRUE;
                    }
                    catch (Throwable throwable) {
                        if (DEBUG) {
                            ExceptionUtils.dumpThrowable("Buffers", throwable);
                        }
                        return Boolean.FALSE;
                    }
                }
            }).booleanValue()) {
                mbbCleaner = methodArray[0];
                cClean = methodArray2[0];
                bl = PlatformPropsImpl.JAVA_9 || null != mbbCleaner && null != cClean;
            } else {
                mbbCleaner = null;
                cClean = null;
                bl = false;
            }
            boolean bl2 = cleanerError = !bl;
            if (DEBUG) {
                System.err.print("Buffers.Cleaner.init: hasCleaner: " + bl + ", cleanerError " + cleanerError);
                if (null != mbbCleaner) {
                    System.err.print(", using Cleaner class: " + mbbCleaner.getReturnType().getName());
                }
                System.err.println();
            }
        }
    }
}

