/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.rendered;

import io.sf.carte.echosvg.ext.awt.image.rendered.LRUCache;
import io.sf.carte.echosvg.ext.awt.image.rendered.TileGenerator;
import io.sf.carte.echosvg.ext.awt.image.rendered.TileLRUMember;
import io.sf.carte.echosvg.ext.awt.image.rendered.TileStore;
import io.sf.carte.echosvg.util.CleanerThread;
import io.sf.carte.echosvg.util.HaltingThread;
import java.awt.Point;
import java.awt.image.Raster;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public class TileMap
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private HashMap<Point, TileMapLRUMember> rasters = new HashMap();
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;

    public TileMap(TileGenerator tileGenerator, LRUCache lRUCache) {
        this.cache = lRUCache;
        this.source = tileGenerator;
    }

    @Override
    public void setTile(int n, int n2, Raster raster) {
        TileMapLRUMember tileMapLRUMember;
        Point point = new Point(n, n2);
        if (raster == null) {
            TileMapLRUMember tileMapLRUMember2 = this.rasters.remove(point);
            if (tileMapLRUMember2 != null) {
                this.cache.remove(tileMapLRUMember2);
            }
            return;
        }
        TileMapLRUMember tileMapLRUMember3 = this.rasters.get(point);
        if (tileMapLRUMember3 == null) {
            tileMapLRUMember = new TileMapLRUMember(this, point, raster);
            this.rasters.put(point, tileMapLRUMember);
        } else {
            tileMapLRUMember = tileMapLRUMember3;
            tileMapLRUMember.setRaster(raster);
        }
        this.cache.add(tileMapLRUMember);
    }

    @Override
    public Raster getTileNoCompute(int n, int n2) {
        Point point = new Point(n, n2);
        TileMapLRUMember tileMapLRUMember = this.rasters.get(point);
        if (tileMapLRUMember == null) {
            return null;
        }
        TileMapLRUMember tileMapLRUMember2 = tileMapLRUMember;
        Raster raster = tileMapLRUMember2.retrieveRaster();
        if (raster != null) {
            this.cache.add(tileMapLRUMember2);
        }
        return raster;
    }

    @Override
    public Raster getTile(int n, int n2) {
        Raster raster = null;
        Point point = new Point(n, n2);
        TileMapLRUMember tileMapLRUMember = this.rasters.get(point);
        TileMapLRUMember tileMapLRUMember2 = null;
        if (tileMapLRUMember != null) {
            tileMapLRUMember2 = tileMapLRUMember;
            raster = tileMapLRUMember2.retrieveRaster();
        }
        if (raster == null) {
            raster = this.source.genTile(n, n2);
            if (HaltingThread.hasBeenHalted()) {
                return raster;
            }
            if (tileMapLRUMember2 != null) {
                tileMapLRUMember2.setRaster(raster);
            } else {
                tileMapLRUMember2 = new TileMapLRUMember(this, point, raster);
                this.rasters.put(point, tileMapLRUMember2);
            }
        }
        this.cache.add(tileMapLRUMember2);
        return raster;
    }

    static class TileMapLRUMember
    extends TileLRUMember {
        public Point pt;
        public SoftReference<TileMap> parent;

        TileMapLRUMember(TileMap tileMap, Point point, Raster raster) {
            super(raster);
            this.parent = new SoftReference<TileMap>(tileMap);
            this.pt = point;
        }

        @Override
        public void setRaster(Raster raster) {
            this.hRaster = raster;
            this.wRaster = new RasterSoftRef(raster);
        }

        class RasterSoftRef
        extends CleanerThread.SoftReferenceCleared<Raster> {
            RasterSoftRef(Raster raster) {
                super((Object)raster);
            }

            public void cleared() {
                TileMap tileMap = TileMapLRUMember.this.parent.get();
                if (tileMap != null) {
                    tileMap.rasters.remove(TileMapLRUMember.this.pt);
                }
            }
        }
    }
}

