/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxComponent;
import java.util.HashMap;
import java.util.Locale;

public class SyntaxParser {
    private static final HashMap<String, CSSValueSyntax.Category> catMap = new HashMap(21);
    private static final CSSValueSyntax universal;

    public static CSSValueSyntax createSimpleSyntax(String string) {
        CSSValueSyntax.Category category = SyntaxParser.category(string = string.toLowerCase(Locale.ROOT));
        if (category != null) {
            return new SyntaxComponent(string, category);
        }
        return null;
    }

    public CSSValueSyntax parseSyntax(String string) throws CSSException {
        SyntaxComponent syntaxComponent;
        int n = (string = string.trim()).length();
        if (n == 0 || n == 2) {
            SyntaxParser.errInvalidDefinition(string);
        }
        char c = string.charAt(0);
        if (n == 1) {
            if (c == '*') {
                return SyntaxParser.getUniversal();
            }
            SyntaxParser.errInvalidDefinition(string);
        }
        if (c == '|' || string.charAt(n - 1) == '|') {
            SyntaxParser.errInvalidDefinition(string);
        }
        SyntaxComponent syntaxComponent2 = syntaxComponent = new SyntaxComponent();
        int n2 = 0;
        block0: while ((n2 = SyntaxParser.parseComponent(string, n2, syntaxComponent2)) < n) {
            while (Character.isWhitespace(c = string.charAt(n2))) {
                if (++n2 != n) continue;
                break block0;
            }
            if (c != '|') {
                SyntaxParser.errInvalidDefinition(string);
            }
            ++n2;
            while (Character.isWhitespace(c = string.charAt(n2))) {
                if (++n2 != n) continue;
                break block0;
            }
            SyntaxComponent syntaxComponent3 = new SyntaxComponent();
            syntaxComponent2.setNext(syntaxComponent3);
            syntaxComponent2 = syntaxComponent3;
        }
        return syntaxComponent;
    }

    private static int parseComponent(String string, int n, SyntaxComponent syntaxComponent) throws CSSException {
        int n2;
        int n3 = string.length();
        while (Character.isWhitespace(n2 = string.codePointAt(n))) {
            if (++n != n3) continue;
            return n3;
        }
        if (n2 == 60) {
            n = SyntaxParser.parseDataType(string, n + 1, syntaxComponent);
        } else if (SyntaxParser.isNameStartCharOrEsc(n2) || n2 == 45) {
            n = SyntaxParser.parseIdent(string, n, syntaxComponent);
        } else {
            throw new CSSException("Unexpected character at definition, index " + n + ": '" + string + '\'');
        }
        return n;
    }

    private static int parseDataType(String string, int n, SyntaxComponent syntaxComponent) throws CSSException {
        int n2;
        int n3 = string.length();
        boolean bl = false;
        int n4 = n;
        while ((n2 = string.codePointAt(n4)) != 62) {
            n4 = string.offsetByCodePoints(n4, 1);
            if (n2 == 92) {
                bl = true;
                continue;
            }
            if (SyntaxParser.isNameChar(n2) && n4 != n3) continue;
            SyntaxParser.errInvalidDefinition(string);
        }
        if (n4 == n) {
            SyntaxParser.errInvalidDefinition(string);
        }
        String string2 = string.substring(n, n4);
        if (bl) {
            string2 = ParseHelper.unescapeStringValue(string2);
        }
        string2 = string2.toLowerCase(Locale.ROOT);
        syntaxComponent.setName(string2);
        CSSValueSyntax.Category category = SyntaxParser.category(string2);
        if (category == null) {
            SyntaxParser.errUnknownDataType(string2, string);
        }
        syntaxComponent.setCategory(category);
        if (++n4 < n3) {
            char c = string.charAt(n4);
            if (c == '#') {
                syntaxComponent.setMultiplier(CSSValueSyntax.Multiplier.NUMBER);
                ++n4;
            } else if (c == '+') {
                syntaxComponent.setMultiplier(CSSValueSyntax.Multiplier.PLUS);
                ++n4;
            }
        }
        return n4;
    }

    private static CSSValueSyntax.Category category(String string) {
        return catMap.get(string);
    }

    private static int parseIdent(String string, int n, SyntaxComponent syntaxComponent) throws CSSException {
        int n2 = string.length();
        int n3 = n;
        int n4 = -2;
        while (n3 < n2) {
            int n5 = string.codePointAt(n3);
            if (n5 == 92) {
                n4 = n4 == n3 - 1 ? -2 : n3;
                ++n3;
                continue;
            }
            if (!SyntaxParser.isNameChar(n5)) {
                if (n4 == -2 || n5 != 32 && n3 != n4 + 1) break;
                n4 = -2;
                ++n3;
                continue;
            }
            if (n4 != -2 && !ParseHelper.isHexCodePoint(n5)) {
                n4 = -2;
            }
            n3 = string.offsetByCodePoints(n3, 1);
        }
        if (n3 == n + 1) {
            SyntaxParser.errInvalidDefinition(string);
        }
        String string2 = string.substring(n, n3);
        string2 = ParseHelper.unescapeStringValue(string2);
        syntaxComponent.setName(string2);
        syntaxComponent.setCategory(CSSValueSyntax.Category.IDENT);
        if (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '#') {
                syntaxComponent.setMultiplier(CSSValueSyntax.Multiplier.NUMBER);
                ++n3;
            } else if (c == '+') {
                syntaxComponent.setMultiplier(CSSValueSyntax.Multiplier.PLUS);
                ++n3;
            }
        }
        return n3;
    }

    private static void errInvalidDefinition(String string) throws CSSException {
        throw new CSSException("Invalid definition: '" + string + '\'');
    }

    private static void errUnknownDataType(String string, String string2) {
        throw new CSSException("Unknown data type '" + string + "' in definition: " + string2);
    }

    private static boolean isNameStartCharOrEsc(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 128 || n == 92 || n == 95;
    }

    private static boolean isNameChar(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n >= 128 || n == 95 || n == 45;
    }

    static CSSValueSyntax getUniversal() {
        return universal;
    }

    static {
        catMap.put("angle", CSSValueSyntax.Category.angle);
        catMap.put("color", CSSValueSyntax.Category.color);
        catMap.put("custom-ident", CSSValueSyntax.Category.customIdent);
        catMap.put("image", CSSValueSyntax.Category.image);
        catMap.put("integer", CSSValueSyntax.Category.integer);
        catMap.put("length", CSSValueSyntax.Category.length);
        catMap.put("length-percentage", CSSValueSyntax.Category.lengthPercentage);
        catMap.put("number", CSSValueSyntax.Category.number);
        catMap.put("percentage", CSSValueSyntax.Category.percentage);
        catMap.put("resolution", CSSValueSyntax.Category.resolution);
        catMap.put("time", CSSValueSyntax.Category.time);
        catMap.put("unicode-range", CSSValueSyntax.Category.unicodeRange);
        catMap.put("transform-function", CSSValueSyntax.Category.transformFunction);
        catMap.put("transform-list", CSSValueSyntax.Category.transformList);
        catMap.put("url", CSSValueSyntax.Category.url);
        catMap.put("string", CSSValueSyntax.Category.string);
        catMap.put("counter", CSSValueSyntax.Category.counter);
        catMap.put("frequency", CSSValueSyntax.Category.frequency);
        catMap.put("flex", CSSValueSyntax.Category.flex);
        universal = new SyntaxComponent("*", CSSValueSyntax.Category.universal);
    }
}

