/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.undo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.undo.CompoundActor;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.undo.SelectionActor;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.ViewController;

public class UndoHandler
implements IUndoHandler {
    private final List<ChangeListener> listeners;
    public static final int COMMIT_DELAY = 2;
    private static final int MAX_ENTRIES = 100;
    private static final long TIME_TO_BEGIN_NEW_ACTION = 100L;
    private boolean actionFrameStarted;
    private ListIterator<CompoundActor> actorIterator;
    private ActorList actorList;
    private boolean isUndoActionRunning = false;
    private final ActionListener redoAction;
    private long timeOfLastAdd;
    private final LinkedList<ActorList> transactionList;
    private final LinkedList<ListIterator<CompoundActor>> transactionIteratorList;
    private final ActionListener undoAction;
    private boolean deactivated;
    private final ChangeEvent event;
    private final MapModel map;

    public UndoHandler(MapModel map) {
        this.map = map;
        this.actionFrameStarted = false;
        this.deactivated = false;
        this.listeners = new LinkedList<ChangeListener>();
        this.actorList = new ActorList();
        this.transactionList = new LinkedList();
        this.transactionIteratorList = new LinkedList();
        this.actorIterator = this.actorList.listIterator();
        this.redoAction = new RedoAction();
        this.timeOfLastAdd = 0L;
        this.undoAction = new UndoAction();
        this.event = new ChangeEvent(this);
    }

    @Override
    public void deactivate() {
        this.deactivated = true;
        this.fireStateChanged();
        this.startActionFrame();
    }

    @Override
    public void addActor(IActor actor) {
        this.resetRedo();
        this.actorList.commitDelay = 2;
        long currentTime = System.currentTimeMillis();
        if (this.deactivated) {
            if (!this.actionFrameStarted && currentTime - this.timeOfLastAdd > 100L) {
                this.deactivated = false;
            } else {
                if (this.actorList.size() > 0) {
                    this.actorList.clear();
                    this.actorIterator = this.actorList.listIterator();
                }
                return;
            }
        }
        if (this.actorList.size() > 0 && (this.actionFrameStarted || currentTime - this.timeOfLastAdd < 100L)) {
            CompoundActor compoundActor = this.actorIterator.previous();
            compoundActor.add(actor);
            this.actorIterator.next();
        } else {
            CompoundActor compoundActor = new CompoundActor();
            Controller controller = Controller.getCurrentController();
            if (this.map == controller.getMap()) {
                IMapSelection selection = controller.getSelection();
                SelectionActor selectionActor = SelectionActor.create(selection);
                compoundActor.add(selectionActor);
            }
            compoundActor.add(actor);
            this.actorIterator.add(compoundActor);
            int maxEntries = 100;
            while (this.actorList.size() > 100) {
                this.actorList.removeFirst();
                this.actorIterator = this.actorList.listIterator(this.actorList.size());
            }
        }
        this.startActionFrame();
        this.timeOfLastAdd = currentTime;
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(this.event);
        }
    }

    @Override
    public boolean canRedo() {
        return this.actorIterator.hasNext();
    }

    @Override
    public boolean canUndo() {
        return this.actorIterator.hasPrevious();
    }

    @Override
    public void commit() {
        this.resetRedo();
        CompoundActor compoundActor = new CompoundActor(this.actorList);
        this.actionFrameStarted = false;
        this.timeOfLastAdd = 0L;
        if (this.transactionList.isEmpty()) {
            LogUtils.warn("transactionList is empty on UndoHandler.commit()");
            return;
        }
        this.actorList = this.transactionList.removeLast();
        this.actorIterator = this.transactionIteratorList.removeLast();
        if (!compoundActor.isEmpty()) {
            this.addActor(compoundActor);
            this.actionFrameStarted = false;
            this.timeOfLastAdd = 0L;
        } else {
            this.fireStateChanged();
        }
    }

    @Override
    public void delayedCommit() {
        if (this.actorList.commitDelay == 0) {
            this.commit();
            return;
        }
        Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                --((UndoHandler)UndoHandler.this).actorList.commitDelay;
                UndoHandler.this.delayedCommit();
            }
        });
    }

    @Override
    public void delayedRollback() {
        if (this.actorList.commitDelay == 0) {
            this.rollback();
            return;
        }
        Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                --((UndoHandler)UndoHandler.this).actorList.commitDelay;
                UndoHandler.this.delayedRollback();
            }
        });
    }

    @Override
    public String getLastDescription() {
        String description = this.canUndo() ? ((CompoundActor)this.actorList.getLast()).getDescription() : null;
        return description;
    }

    @Override
    public ActionListener getRedoAction() {
        return this.redoAction;
    }

    @Override
    public ActionListener getUndoAction() {
        return this.undoAction;
    }

    @Override
    public boolean isUndoActionRunning() {
        return this.isUndoActionRunning;
    }

    @Override
    public void redo() {
        if (this.canRedo()) {
            IActor redoActor = this.actorIterator.next();
            this.isUndoActionRunning = true;
            redoActor.act();
            this.isUndoActionRunning = false;
            this.fireStateChanged();
        }
    }

    @Override
    public void resetRedo() {
        while (this.canRedo()) {
            this.actorIterator.next();
            this.actorIterator.remove();
        }
        this.fireStateChanged();
    }

    @Override
    public void rollback() {
        try {
            this.isUndoActionRunning = true;
            while (this.actorIterator.hasPrevious()) {
                IActor actor = this.actorIterator.previous();
                actor.undo();
            }
        }
        finally {
            this.isUndoActionRunning = false;
        }
        if (this.transactionList.isEmpty()) {
            LogUtils.warn("transactionList is empty on UndoHandler.rollback()");
            return;
        }
        this.actorList = this.transactionList.removeLast();
        this.actorIterator = this.transactionIteratorList.removeLast();
        this.fireStateChanged();
    }

    private void startActionFrame() {
        ViewController viewController;
        if (!this.actionFrameStarted && (viewController = Controller.getCurrentController().getViewController()).isDispatchThread()) {
            this.actionFrameStarted = true;
            viewController.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UndoHandler.this.actionFrameStarted = false;
                }
            });
        }
    }

    @Override
    public void forceNewTransaction() {
        this.timeOfLastAdd = 0L;
        this.actionFrameStarted = false;
    }

    @Override
    public void startTransaction() {
        ActorList newActorList;
        this.transactionList.addLast(this.actorList);
        this.transactionIteratorList.addLast(this.actorIterator);
        this.actorList = newActorList = new ActorList();
        this.actorIterator = newActorList.listIterator();
    }

    @Override
    public void undo() {
        if (this.canUndo()) {
            IActor actor = this.actorIterator.previous();
            try {
                this.isUndoActionRunning = true;
                actor.undo();
            }
            finally {
                this.isUndoActionRunning = false;
                this.fireStateChanged();
            }
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getTransactionLevel() {
        return this.transactionList.size();
    }

    private static class ActorList
    extends LinkedList<CompoundActor> {
        private static final long serialVersionUID = 1L;
        int commitDelay = 2;

        private ActorList() {
        }
    }

    private class RedoAction
    implements ActionListener {
        private RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UndoHandler.this.redo();
        }
    }

    private class UndoAction
    implements ActionListener {
        private UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UndoHandler.this.undo();
        }
    }
}

