\name{ThresholdMaximumConnectedComponentsImageFilter}
\alias{ThresholdMaximumConnectedComponentsImageFilter}
\title{ThresholdMaximumConnectedComponentsImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Finds the threshold value of an image based on maximizing the number
of objects in the image that are larger than a given minimal size.
ThresholdMaximumConnectedComponentsImageFilter}
\details{
This method is based on Topological Stable State Thresholding to
calculate the threshold set point. This method is particularly
effective when there are a large number of objects in a microscopy
image. Compiling in Debug mode and enable the debug flag for this
filter to print debug information to see how the filter focuses in on
a threshold value. Please see the Insight Journal's MICCAI 2005
workshop for a complete description. References are below.
Parameters
The MinimumObjectSizeInPixels parameter is controlled through the
class Get/SetMinimumObjectSizeInPixels() method. Similar to the
standard itk::BinaryThresholdImageFilter the Get/SetInside and Get/SetOutside values of the threshold can be
set. The GetNumberOfObjects() and GetThresholdValue() methods return
the number of objects above the minimum pixel size and the calculated
threshold value.
Automatic Thresholding in ITK
There are multiple methods to automatically calculate the threshold
intensity value of an image. As of version 4.0, ITK has a Thresholding
( ITKThresholding ) module which contains numerous automatic
thresholding methods.implements two of these. Topological Stable State
Thresholding works well on images with a large number of objects to be
counted.
References:
1) Urish KL, August J, Huard J. "Unsupervised segmentation for
myofiber counting in immunofluorescent microscopy images". Insight
Journal. ISC/NA-MIC/MICCAI Workshop on Open-Source Software (2005) https://insight-journal.org/browse/publication/40 2) Pikaz A, Averbuch, A. "Digital image thresholding based on
topological stable-state". Pattern Recognition, 29(5): 829-843, 1996.
Questions: email Ken Urish at ken.urish(at)gmail.com Please cc the itk
list serve for archival purposes.
See:
ThresholdMaximumConnectedComponents for the procedural interface
itk::ThresholdMaximumConnectedComponentsImageFilter for the Doxygen on the original ITK class.
ThresholdMaximumConnectedComponentsImageFilter}
%C++ includes: sitkThresholdMaximumConnectedComponentsImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{uint8_t GetInsideValue() const:}{
The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.
}
\item{uint32_t GetMinimumObjectSizeInPixels() const:}{
The pixel type must support comparison operators. Set the minimum
pixel area used to count objects on the image. Thus, only objects that
have a pixel area greater than the minimum pixel area will be counted
as an object in the optimization portion of this filter. Essentially,
it eliminates noise from being counted as an object. The default value
is zero.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint8_t GetOutsideValue() const:}{
The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.
}
\item{double GetUpperBoundary() const:}{
The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.
}
\item{Self SetInsideValue(uint8_t InsideValue):}{
The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.
}
\item{Self SetMinimumObjectSizeInPixels(uint32_t MinimumObjectSizeInPixels):}{
The pixel type must support comparison operators. Set the minimum
pixel area used to count objects on the image. Thus, only objects that
have a pixel area greater than the minimum pixel area will be counted
as an object in the optimization portion of this filter. Essentially,
it eliminates noise from being counted as an object. The default value
is zero.
}
\item{Self SetOutsideValue(uint8_t OutsideValue):}{
The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.
}
\item{Self SetUpperBoundary(double UpperBoundary):}{
The following Set/Get methods are for the binary threshold function.
This class automatically calculates the lower threshold boundary. The
upper threshold boundary, inside value, and outside value can be
defined by the user, however the standard values are used as default
if not set by the user. The default value of the: Inside value is the
maximum pixel type intensity. Outside value is the minimum pixel type
intensity. Upper threshold boundary is the maximum pixel type
intensity.
}
\item{ ThresholdMaximumConnectedComponentsImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ThresholdMaximumConnectedComponentsImageFilter():}{
Destructor
}
}
}
